/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.kocakosm.pitaya.collection.AbstractBag;
import org.kocakosm.pitaya.collection.Bag;
import org.kocakosm.pitaya.collection.HashBag;
import org.kocakosm.pitaya.collection.UnmodifiableIterator;

public final class ImmutableBag<E>
extends AbstractBag<E>
implements Serializable {
    private static final long serialVersionUID = 194306588498543706L;
    private final Bag<E> inner;

    public static <E> Bag<E> copyOf(Collection<? extends E> c) {
        return new ImmutableBag<E>(new HashBag<E>(c));
    }

    public static <E> Bag<E> copyOf(Iterable<? extends E> i) {
        return new ImmutableBag<E>(new HashBag<E>(i));
    }

    public static <E> Bag<E> copyOf(Iterator<? extends E> i) {
        return new ImmutableBag<E>(new HashBag<E>(i));
    }

    public static <E> Bag<E> copyOf(E[] values) {
        return new ImmutableBag<E>(new HashBag<E>(values));
    }

    public static <E> Bag<E> of(E ... values) {
        return new ImmutableBag<E>(new HashBag<E>(values));
    }

    private ImmutableBag(Bag<E> inner) {
        this.inner = inner;
    }

    @Override
    public int count(E e) {
        return this.inner.count(e);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableIterator(this.inner.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static final class Builder<E> {
        private final Bag<E> inner = new HashBag();

        public Builder<E> add(E ... values) {
            this.inner.addAll(Arrays.asList(values));
            return this;
        }

        public Builder<E> add(Iterable<? extends E> values) {
            for (E value : values) {
                this.inner.add(value);
            }
            return this;
        }

        public Builder<E> add(Iterator<? extends E> values) {
            while (values.hasNext()) {
                this.inner.add(values.next());
            }
            return this;
        }

        public Bag<E> build() {
            return new ImmutableBag(this.inner);
        }
    }
}

