/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kocakosm.pitaya.collection.Iterables;
import org.kocakosm.pitaya.collection.Iterators;
import org.kocakosm.pitaya.collection.UnmodifiableIterator;

public final class ImmutableSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 6744093868687684286L;
    private final Set<E> inner;

    public static <E> Set<E> copyOf(Collection<? extends E> c) {
        return new ImmutableSet<E>(new HashSet<E>(c));
    }

    public static <E> Set<E> copyOf(Iterable<? extends E> i) {
        return new ImmutableSet<E>(Iterables.toSet(i));
    }

    public static <E> Set<E> copyOf(Iterator<? extends E> i) {
        return new ImmutableSet<E>(Iterators.toSet(i));
    }

    public static <E> Set<E> copyOf(E[] values) {
        return new ImmutableSet<E>(new HashSet<E>(Arrays.asList(values)));
    }

    public static <E> Set<E> of(E ... values) {
        return new ImmutableSet<E>(new HashSet<E>(Arrays.asList(values)));
    }

    private ImmutableSet(Set<E> inner) {
        this.inner = inner;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableIterator<E>(this.inner.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static final class Builder<E> {
        private final Set<E> inner = new HashSet();

        public Builder<E> add(E ... values) {
            this.inner.addAll(Arrays.asList(values));
            return this;
        }

        public Builder<E> add(Iterable<? extends E> values) {
            for (E value : values) {
                this.inner.add(value);
            }
            return this;
        }

        public Builder<E> add(Iterator<? extends E> values) {
            while (values.hasNext()) {
                this.inner.add(values.next());
            }
            return this;
        }

        public Set<E> build() {
            return new ImmutableSet(this.inner);
        }
    }
}

