/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.kocakosm.pitaya.util.Parameters;

public final class CountingInputStream
extends InputStream {
    private final InputStream in;
    private final AtomicLong counter;

    public CountingInputStream(InputStream in) {
        Parameters.checkNotNull(in);
        this.in = in;
        this.counter = new AtomicLong();
    }

    public long getCount() {
        return this.counter.get();
    }

    public long resetCount() {
        return this.counter.getAndSet(0L);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        this.count(b != -1 ? 1 : -1);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = this.in.read(b);
        this.count(n);
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        this.count(n);
        return n;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    private void count(int n) {
        if (n != -1) {
            this.counter.addAndGet(n);
        }
    }
}

