/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.kocakosm.pitaya.util.Parameters;

public final class CountingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final AtomicLong counter;

    public CountingOutputStream(OutputStream out) {
        Parameters.checkNotNull(out);
        this.out = out;
        this.counter = new AtomicLong();
    }

    public long getCount() {
        return this.counter.get();
    }

    public long resetCount() {
        return this.counter.getAndSet(0L);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int i) throws IOException {
        this.out.write(i);
        this.counter.incrementAndGet();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.counter.addAndGet(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.counter.addAndGet(Math.min(b.length - off, len));
    }
}

