/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicLong;
import org.kocakosm.pitaya.util.Parameters;

public final class CountingReader
extends Reader {
    private final Reader reader;
    private final AtomicLong counter;

    public CountingReader(Reader reader) {
        Parameters.checkNotNull(reader);
        this.reader = reader;
        this.counter = new AtomicLong();
    }

    public long getCount() {
        return this.counter.get();
    }

    public long resetCount() {
        return this.counter.getAndSet(0L);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public int read() throws IOException {
        int b = this.reader.read();
        this.count(b != -1 ? 1 : -1);
        return b;
    }

    @Override
    public int read(char[] buf) throws IOException {
        int n = this.reader.read(buf);
        this.count(n);
        return n;
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        int n = this.reader.read(buf, off, len);
        this.count(n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public void mark(int readLimit) throws IOException {
        this.reader.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void count(int n) {
        if (n != -1) {
            this.counter.addAndGet(n);
        }
    }
}

