/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;

public final class ObjectCodec {
    public static byte[] encode(Serializable object) {
        byte[] byArray;
        Parameters.checkNotNull(object);
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(out);
            oos.writeObject(object);
            oos.flush();
            byArray = out.toByteArray();
        }
        catch (IOException ex) {
            try {
                throw new EncodingException(ex);
            }
            catch (Throwable throwable) {
                IO.close(oos);
                throw throwable;
            }
        }
        IO.close(oos);
        return byArray;
    }

    public static Serializable decode(byte[] bytes) {
        return ObjectCodec.decode(bytes, Serializable.class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T decode(byte[] bytes, Class<T> t) {
        Serializable serializable;
        Parameters.checkNotNull(t);
        Parameters.checkNotNull(bytes);
        ObjectInputStream ois = null;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            ois = new ObjectInputStream(in);
            serializable = (Serializable)Parameters.checkType(ois.readObject(), t);
        }
        catch (IOException ex) {
            try {
                throw new DecodingException(ex);
                catch (ClassNotFoundException ex2) {
                    throw new DecodingException(ex2);
                }
            }
            catch (Throwable throwable) {
                IO.close(ois);
                throw throwable;
            }
        }
        IO.close(ois);
        return (T)serializable;
    }

    private ObjectCodec() {
    }

    public static final class DecodingException
    extends RuntimeException {
        private static final long serialVersionUID = 39875873692107851L;

        private DecodingException(Throwable cause) {
            super(cause);
        }
    }

    public static final class EncodingException
    extends RuntimeException {
        private static final long serialVersionUID = 27396917846938764L;

        private EncodingException(Throwable cause) {
            super(cause);
        }
    }
}

