/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.InputStream;
import java.util.Random;
import org.kocakosm.pitaya.util.Parameters;

public final class RandomInputStream
extends InputStream {
    private static final Random PRNG = new Random();
    private final Random prng;

    public RandomInputStream() {
        this(PRNG);
    }

    public RandomInputStream(Random prng) {
        Parameters.checkNotNull(prng);
        this.prng = prng;
    }

    @Override
    public int read() {
        return this.prng.nextInt(256);
    }

    @Override
    public int read(byte[] b) {
        this.prng.nextBytes(b);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] tmp = new byte[len];
        this.prng.nextBytes(tmp);
        System.arraycopy(tmp, 0, b, off, len);
        return len;
    }
}

