/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.Reader;
import java.util.Arrays;
import java.util.Random;
import org.kocakosm.pitaya.util.Parameters;

public final class RandomReader
extends Reader {
    private static final Random PRNG = new Random();
    private final Random prng;
    private final char[] alphabet;

    public RandomReader(char ... alphabet) {
        this(PRNG, alphabet);
    }

    public RandomReader(Random prng, char ... alphabet) {
        Parameters.checkNotNull(prng);
        Parameters.checkCondition(alphabet.length > 0);
        this.prng = prng;
        this.alphabet = Arrays.copyOf(alphabet, alphabet.length);
    }

    @Override
    public int read() {
        return this.alphabet[this.prng.nextInt(this.alphabet.length)];
    }

    @Override
    public int read(char[] cbuf) {
        for (int i = 0; i < cbuf.length; ++i) {
            cbuf[i] = (char)this.read();
        }
        return cbuf.length;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (off < 0 || len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            cbuf[off + i] = (char)this.read();
        }
        return len;
    }

    @Override
    public void close() {
    }
}

