/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.Reader;
import java.util.Arrays;
import org.kocakosm.pitaya.util.Parameters;

public final class StringReader
extends Reader {
    private int index;
    private int mark;
    private final StringBuilder in = new StringBuilder();

    public StringReader(String ... strings) {
        this(Arrays.asList(strings));
    }

    public StringReader(Iterable<String> strings) {
        for (String str : strings) {
            Parameters.checkNotNull(str);
            this.in.append(str);
        }
        this.in.trimToSize();
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public int read() {
        return this.finished() ? -1 : (int)this.in.charAt(this.index++);
    }

    @Override
    public int read(char[] buf) {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(char[] buf, int off, int len) {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.finished()) {
            return -1;
        }
        int n = 0;
        for (int i = off; i < off + len && this.index < this.in.length(); ++i) {
            buf[i] = this.in.charAt(this.index++);
            ++n;
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        Parameters.checkCondition(readLimit >= 0);
        this.mark = this.index;
    }

    @Override
    public void reset() {
        this.index = this.mark;
    }

    @Override
    public long skip(long n) {
        Parameters.checkCondition(n >= 0L);
        if (this.finished()) {
            return 0L;
        }
        long skipped = n;
        if (n > (long)(this.in.length() - this.index)) {
            skipped = this.in.length() - this.index;
        }
        this.index = (int)((long)this.index + skipped);
        return skipped;
    }

    @Override
    public void close() {
    }

    private boolean finished() {
        return this.index >= this.in.length();
    }
}

