/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;

final class TeeOutputStream
extends OutputStream {
    private final List<OutputStream> streams = new ArrayList<OutputStream>();

    TeeOutputStream(OutputStream ... streams) {
        this(Arrays.asList(streams));
    }

    TeeOutputStream(Iterable<? extends OutputStream> streams) {
        for (OutputStream outputStream : streams) {
            Parameters.checkNotNull(outputStream);
            this.streams.add(outputStream);
        }
    }

    @Override
    public void close() {
        for (OutputStream out : this.streams) {
            IO.close(out);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream out : this.streams) {
            out.flush();
        }
    }

    @Override
    public void write(int i) throws IOException {
        for (OutputStream out : this.streams) {
            out.write(i);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream out : this.streams) {
            out.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream out : this.streams) {
            out.write(b, off, len);
        }
    }
}

