/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.util.Parameters;

final class TeeWriter
extends Writer {
    private final List<Writer> writers = new ArrayList<Writer>();

    TeeWriter(Writer ... writers) {
        this(Arrays.asList(writers));
    }

    TeeWriter(Iterable<? extends Writer> writers) {
        for (Writer writer : writers) {
            Parameters.checkNotNull(writer);
            this.writers.add(writer);
        }
    }

    @Override
    public TeeWriter append(char c) throws IOException {
        for (Writer writer : this.writers) {
            writer.append(c);
        }
        return this;
    }

    @Override
    public TeeWriter append(CharSequence sequence) throws IOException {
        for (Writer writer : this.writers) {
            writer.append(sequence);
        }
        return this;
    }

    @Override
    public TeeWriter append(CharSequence sequence, int start, int end) throws IOException {
        return this.append(sequence.subSequence(start, end));
    }

    @Override
    public void write(int c) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(c);
        }
    }

    @Override
    public void write(char[] buf) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(buf);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(buf, off, len);
        }
    }

    @Override
    public void write(String str) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, off + len));
    }

    @Override
    public void flush() throws IOException {
        for (Writer writer : this.writers) {
            writer.flush();
        }
    }

    @Override
    public void close() {
        for (Writer writer : this.writers) {
            IO.close(writer);
        }
    }
}

