/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.net;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kocakosm.pitaya.charset.ASCII;
import org.kocakosm.pitaya.charset.Charsets;
import org.kocakosm.pitaya.net.URNSyntaxException;
import org.kocakosm.pitaya.util.BaseEncoding;
import org.kocakosm.pitaya.util.Parameters;

public final class URN
implements Serializable {
    private static final long serialVersionUID = 6295350526747423877L;
    private static final Pattern PATTERN;
    private final String scheme;
    private final String nid;
    private final String nss;

    public static URN create(String urn) {
        try {
            return new URN(urn);
        }
        catch (URNSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public URN(String urn) throws URNSyntaxException {
        Matcher m = PATTERN.matcher(Parameters.checkNotNull(urn));
        if (!m.matches()) {
            throw new URNSyntaxException("Invalid URN: " + urn);
        }
        this.scheme = m.group(1);
        this.nid = m.group(2);
        this.nss = m.group(3);
        this.checkNID(this.nid);
        this.checkNSS(this.nss);
    }

    public URN(String nid, String nss) throws URNSyntaxException {
        this("urn", nid, nss);
    }

    public URN(String scheme, String nid, String nss) throws URNSyntaxException {
        this(Parameters.checkNotNull(scheme) + ":" + Parameters.checkNotNull(nid) + ":" + Parameters.checkNotNull(nss));
    }

    private void checkNID(String nid) throws URNSyntaxException {
        if ("urn".equalsIgnoreCase(nid)) {
            throw new URNSyntaxException("Invalid NID: " + nid);
        }
    }

    private void checkNSS(String nss) throws URNSyntaxException {
        int len = nss.length();
        char[] chars = nss.toCharArray();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (chars[i] != '%') continue;
            sb.append(chars[++i]).append(chars[++i]);
            if (i != len - 1 && chars[i + 1] == '%') continue;
            this.checkIsValidUTF8(this.decodeBase16(sb));
            sb.setLength(0);
        }
    }

    private byte[] decodeBase16(CharSequence hex) {
        return BaseEncoding.BASE_16.decode(hex.toString());
    }

    private void checkIsValidUTF8(byte[] bytes) throws URNSyntaxException {
        Charset utf8 = Charsets.UTF_8;
        byte[] reencoded = new String(bytes, utf8).getBytes(utf8);
        if (!Arrays.equals(bytes, reencoded)) {
            throw new URNSyntaxException("Invalid NSS: Invalid UTF-8 encoding");
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public String nid() {
        return this.nid;
    }

    public String nss() {
        return this.nss;
    }

    public URN normalized() {
        return URN.create("urn:" + ASCII.toLowerCase(this.nid) + ":" + this.normalizeNSS(this.nss));
    }

    private String normalizeNSS(String nss) {
        char[] chars = nss.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%') {
                sb.append('%');
                sb.append(ASCII.toLowerCase(chars[++i]));
                sb.append(ASCII.toLowerCase(chars[++i]));
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String toString() {
        return this.scheme + ":" + this.nid + ":" + this.nss;
    }

    public int hashCode() {
        return this.normalized().nss.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URN)) {
            return false;
        }
        URN u = this.normalized();
        URN t = ((URN)o).normalized();
        return u.nid.equals(t.nid) && u.nss.equals(t.nss);
    }

    static {
        String regex = "(^urn):([a-z0-9][a-z0-9\\-]{0,31}):(([a-z0-9()+,\\-.:=@;$_!*']|%[0-9a-f]{2})+$)";
        PATTERN = Pattern.compile(regex, 2);
    }
}

