/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.Factory;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.security.MAC;
import org.kocakosm.pitaya.util.BaseEncoding;
import org.kocakosm.pitaya.util.ByteBuffer;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XArrays;
import org.kocakosm.pitaya.util.XObjects;

final class HKDF
implements KDF {
    private final int dkLen;
    private final byte[] info;
    private final Algorithm<MAC> algorithm;

    HKDF(Algorithm<MAC> algorithm, byte[] info, int dkLen) {
        Parameters.checkCondition(dkLen > 0);
        MAC mac = Factory.newMAC(algorithm, new byte[0]);
        Parameters.checkCondition(dkLen <= 255 * mac.length());
        this.algorithm = algorithm;
        this.dkLen = dkLen;
        this.info = info == null ? new byte[]{} : XArrays.copyOf(info);
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] salt) {
        return this.expand(this.extract(secret, salt));
    }

    private byte[] extract(byte[] key, byte[] salt) {
        return Factory.newMAC(this.algorithm, salt).digest(key);
    }

    private byte[] expand(byte[] key) {
        MAC mac = Factory.newMAC(this.algorithm, key);
        ByteBuffer t = new ByteBuffer(this.dkLen + mac.length());
        int n = (int)Math.ceil((double)this.dkLen / (double)mac.length());
        byte[] u = new byte[]{};
        for (int i = 1; i <= n; ++i) {
            u = mac.update(u).update(this.info).digest((byte)i);
            t.append(u);
        }
        return t.toByteArray(0, this.dkLen);
    }

    public String toString() {
        return XObjects.toStringBuilder("HKDF").append("MAC", this.algorithm).append("info", "0x" + BaseEncoding.BASE_16.encode(this.info)).append("dkLen", this.dkLen).toString();
    }
}

