/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.util.Arrays;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.security.Digests;
import org.kocakosm.pitaya.security.MAC;

public final class HMAC {
    public static MAC md2(byte ... key) {
        return new Engine(key, Digests.md2(), 16);
    }

    public static MAC md4(byte ... key) {
        return new Engine(key, Digests.md4(), 64);
    }

    public static MAC md5(byte ... key) {
        return new Engine(key, Digests.md5(), 64);
    }

    public static MAC sha1(byte ... key) {
        return new Engine(key, Digests.sha1(), 64);
    }

    public static MAC sha256(byte ... key) {
        return new Engine(key, Digests.sha256(), 64);
    }

    public static MAC sha512(byte ... key) {
        return new Engine(key, Digests.sha512(), 128);
    }

    public static MAC keccak224(byte ... key) {
        return new Engine(key, Digests.keccak224(), 144);
    }

    public static MAC keccak256(byte ... key) {
        return new Engine(key, Digests.keccak256(), 136);
    }

    public static MAC keccak384(byte ... key) {
        return new Engine(key, Digests.keccak384(), 104);
    }

    public static MAC keccak512(byte ... key) {
        return new Engine(key, Digests.keccak512(), 72);
    }

    private HMAC() {
    }

    private static final class Engine
    implements MAC {
        private final byte[] key;
        private final Digest digest;

        Engine(byte[] key, Digest digest, int blockSize) {
            byte[] k = key.length > blockSize ? digest.digest(key) : key;
            this.key = Arrays.copyOf(k, blockSize);
            this.digest = digest;
            this.reset();
        }

        @Override
        public int length() {
            return this.digest.length();
        }

        @Override
        public MAC reset() {
            this.digest.reset();
            for (byte b : this.key) {
                this.digest.update((byte)(b & 0xFF ^ 0x36));
            }
            return this;
        }

        @Override
        public MAC update(byte input) {
            this.digest.update(input);
            return this;
        }

        @Override
        public MAC update(byte ... input) {
            this.digest.update(input);
            return this;
        }

        @Override
        public MAC update(byte[] input, int off, int len) {
            this.digest.update(input, off, len);
            return this;
        }

        @Override
        public byte[] digest() {
            byte[] hash = this.digest.digest();
            for (byte b : this.key) {
                this.digest.update((byte)(b & 0xFF ^ 0x5C));
            }
            byte[] hmac = this.digest.digest(hash);
            this.reset();
            return hmac;
        }

        @Override
        public byte[] digest(byte ... input) {
            return this.update(input).digest();
        }

        @Override
        public byte[] digest(byte[] input, int off, int len) {
            return this.update(input, off, len).digest();
        }

        public String toString() {
            return "HMAC-" + this.digest;
        }
    }
}

