/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.Factory;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.security.MAC;
import org.kocakosm.pitaya.util.BigEndian;
import org.kocakosm.pitaya.util.ByteBuffer;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.XObjects;

final class PBKDF2
implements KDF {
    private final int dkLen;
    private final int iterationCount;
    private final Algorithm<MAC> algorithm;

    PBKDF2(Algorithm<MAC> algorithm, int iterationCount, int dkLen) {
        Parameters.checkCondition(dkLen > 0);
        Parameters.checkCondition(iterationCount > 0);
        Factory.newMAC(algorithm, new byte[0]);
        this.algorithm = algorithm;
        this.iterationCount = iterationCount;
        this.dkLen = dkLen;
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] salt) {
        MAC mac = Factory.newMAC(this.algorithm, secret);
        int d = (int)Math.ceil((double)this.dkLen / (double)mac.length());
        ByteBuffer t = new ByteBuffer(d * mac.length());
        for (int i = 1; i <= d; ++i) {
            byte[] f;
            byte[] u = f = mac.update(salt).digest(BigEndian.encode(i));
            for (int j = 1; j < this.iterationCount; ++j) {
                u = mac.digest(u);
                for (int k = 0; k < f.length; ++k) {
                    int n = k;
                    f[n] = (byte)(f[n] ^ u[k]);
                }
            }
            t.append(f);
        }
        return t.toByteArray(0, this.dkLen);
    }

    public String toString() {
        return XObjects.toStringBuilder("PBKDF2").append("MAC", this.algorithm).append("iterationCount", this.iterationCount).append("dkLen", this.dkLen).toString();
    }
}

