/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.kocakosm.pitaya.charset.UTF8;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.security.KDFs;
import org.kocakosm.pitaya.util.ByteBuffer;
import org.kocakosm.pitaya.util.Strings;

public final class Passwords {
    private static final int R = 8;
    private static final int P = 1;
    private static final int N = 16384;
    private static final int R_MIN = 8;
    private static final int P_MIN = 1;
    private static final int N_MIN = 16384;
    private static final int SALT_LENGTH = 16;
    private static final int HASH_LENGTH = 32;
    private static final Random PRNG = new SecureRandom();
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String generate() {
        return Strings.random(10, PRNG, ALPHABET);
    }

    public static byte[] hash(String password) {
        return Passwords.hash(password, Passwords.salt(), 8, 16384, 1);
    }

    public static boolean verify(String password, byte[] hash) {
        byte[] h = Arrays.copyOf(hash, 51);
        int n = 1 << (h[48] & 0xFF);
        int r = h[49] & 0xFF;
        int p = h[50] & 0xFF;
        if (n > 16384 || n < 16384 || r > 8 || r < 8 || p > 1 || p < 1) {
            n = 16384;
            r = 8;
            p = 1;
        }
        byte[] salt = new byte[16];
        System.arraycopy(h, 32, salt, 0, 16);
        byte[] expected = Passwords.hash(password, salt, r, n, p);
        int result = 0;
        for (int i = 0; i < h.length; ++i) {
            result |= h[i] ^ expected[i];
        }
        return result == 0;
    }

    private static byte[] hash(String password, byte[] salt, int r, int n, int p) {
        KDF scrypt = KDFs.scrypt(r, n, p, 32);
        ByteBuffer buf = new ByteBuffer(51);
        buf.append(scrypt.deriveKey(UTF8.encode(password), salt));
        buf.append(salt);
        buf.append((byte)Math.round(Math.log(n) / Math.log(2.0)));
        buf.append((byte)r, (byte)p);
        return buf.toByteArray();
    }

    private static byte[] salt() {
        byte[] salt = new byte[16];
        PRNG.nextBytes(salt);
        return salt;
    }

    private Passwords() {
    }
}

