/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.time;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.kocakosm.pitaya.math.Numbers;
import org.kocakosm.pitaya.util.Parameters;

public final class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = 2629881563004939761L;
    public static final Duration ZERO = new Duration(0L);
    public static final Duration ONE_MILLISECOND = new Duration(1L);
    public static final Duration ONE_SECOND = new Duration(1000L);
    public static final Duration ONE_MINUTE = new Duration(60000L);
    public static final Duration ONE_HOUR = new Duration(3600000L);
    public static final Duration ONE_DAY = new Duration(86400000L);
    public static final Duration ONE_WEEK = new Duration(604800000L);
    private final long milliseconds;

    public static Duration valueOf(String duration) {
        String[] tokens = duration.toLowerCase().replace("and", "").replaceAll("[,&\\+]", " ").replaceAll("-\\s+", "-").replace("--", "").replaceAll("[\n\t\r]", " ").trim().replaceAll("\\s+", " ").split("\\s");
        Parameters.checkCondition(tokens.length % 2 == 0);
        long ms = 0L;
        for (int i = 0; i < tokens.length; i += 2) {
            long v = Long.parseLong(tokens[i]);
            TimeUnit u = Duration.parseTimeUnit(tokens[i + 1]);
            ms = Numbers.safeAdd(ms, TimeUnit.MILLISECONDS.convert(v, u));
        }
        return new Duration(ms);
    }

    private static TimeUnit parseTimeUnit(String unit) {
        for (Unit u : Unit.values()) {
            for (String name : u.names) {
                if (!unit.equals(name)) continue;
                return u.unit;
            }
        }
        throw new IllegalArgumentException("Unknown unit: " + unit);
    }

    public static Duration of(long amount, TimeUnit unit) {
        long duration = TimeUnit.MILLISECONDS.convert(amount, unit);
        if (unit.convert(duration, TimeUnit.MILLISECONDS) != amount) {
            throw new ArithmeticException("Too large duration: " + amount + " " + (Object)((Object)unit));
        }
        return new Duration(duration);
    }

    public static Duration of(Duration ... durations) {
        if (durations.length == 0) {
            return new Duration(0L);
        }
        long ms = durations[0].milliseconds;
        for (int i = 1; i < durations.length; ++i) {
            ms = Numbers.safeAdd(ms, durations[i].milliseconds);
        }
        return new Duration(ms);
    }

    public static Duration between(Date start, Date end) {
        return new Duration(end.getTime() - start.getTime());
    }

    public static Duration since(Date d) {
        return new Duration(Duration.now() - d.getTime());
    }

    public static Duration until(Date d) {
        return new Duration(d.getTime() - Duration.now());
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private Duration(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public Duration plus(Duration d) {
        return new Duration(Numbers.safeAdd(this.milliseconds, d.milliseconds));
    }

    public Duration minus(Duration d) {
        return new Duration(Numbers.safeSubtract(this.milliseconds, d.milliseconds));
    }

    public Duration multipliedBy(int factor) {
        return new Duration(Numbers.safeMultiply(this.milliseconds, (long)factor));
    }

    public Duration dividedBy(int divisor) {
        return new Duration(Numbers.safeDivide(this.milliseconds, (long)divisor));
    }

    public int sign() {
        return this.milliseconds > 0L ? 1 : (this.milliseconds < 0L ? -1 : 0);
    }

    public Duration negated() {
        return new Duration(Numbers.safeNegate(this.milliseconds));
    }

    public Duration absoluteValue() {
        return new Duration(Numbers.safeAbs(this.milliseconds));
    }

    public Date after(Date d) {
        return new Date(Numbers.safeAdd(d.getTime(), this.milliseconds));
    }

    public Date before(Date d) {
        return new Date(Numbers.safeSubtract(d.getTime(), this.milliseconds));
    }

    public long to(TimeUnit unit) {
        return unit.convert(this.milliseconds, TimeUnit.MILLISECONDS);
    }

    public long toMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public int compareTo(Duration d) {
        try {
            long c = Numbers.safeSubtract(this.milliseconds, d.milliseconds);
            return c > 0L ? 1 : (c < 0L ? -1 : 0);
        }
        catch (ArithmeticException e) {
            return this.sign();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration d = (Duration)o;
        return this.milliseconds == d.milliseconds;
    }

    public int hashCode() {
        return (int)(this.milliseconds ^ this.milliseconds >>> 32);
    }

    public String toString() {
        if (this.milliseconds == 0L) {
            return "0 millisecond";
        }
        StringBuilder sb = new StringBuilder();
        long time = this.milliseconds;
        long days = TimeUnit.MILLISECONDS.toDays(time);
        this.append(sb, days, "day");
        long hours = TimeUnit.MILLISECONDS.toHours(time -= TimeUnit.DAYS.toMillis(days));
        this.append(sb, hours, "hour");
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time -= TimeUnit.HOURS.toMillis(hours));
        this.append(sb, minutes, "minute");
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time -= TimeUnit.MINUTES.toMillis(minutes));
        this.append(sb, seconds, "second");
        this.append(sb, time -= TimeUnit.SECONDS.toMillis(seconds), "millisecond");
        return sb.toString();
    }

    private void append(StringBuilder sb, long value, String unit) {
        if (value != 0L) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value).append(' ').append(unit);
            if (value != 1L && value != -1L) {
                sb.append('s');
            }
        }
    }

    private static enum Unit {
        MS(TimeUnit.MILLISECONDS, "milliseconds", "millisecond", "millis", "ms"),
        S(TimeUnit.SECONDS, "seconds", "second", "sec", "secs", "s"),
        M(TimeUnit.MINUTES, "minutes", "minute", "min", "mins", "m"),
        H(TimeUnit.HOURS, "hours", "hour", "h"),
        D(TimeUnit.DAYS, "days", "day", "d");

        private final TimeUnit unit;
        private final String[] names;

        private Unit(TimeUnit unit, String ... names) {
            this.unit = unit;
            this.names = names;
        }
    }
}

