/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.time;

import java.util.concurrent.TimeUnit;
import org.kocakosm.pitaya.time.Duration;

public final class Stopwatch {
    private long referenceTime = this.now();
    private long elapsedTime = 0L;
    private boolean running = false;

    public boolean isRunning() {
        return this.running;
    }

    public Stopwatch start() {
        if (this.running) {
            throw new IllegalStateException("Already running...");
        }
        this.referenceTime = this.now();
        this.running = true;
        return this;
    }

    public Stopwatch stop() {
        if (!this.running) {
            throw new IllegalStateException("Already idle...");
        }
        this.elapsedTime += this.now() - this.referenceTime;
        this.running = false;
        return this;
    }

    public Stopwatch reset() {
        this.elapsedTime = 0L;
        this.referenceTime = this.now();
        return this;
    }

    public long elapsedTime() {
        if (this.running) {
            return (this.elapsedTime + this.now() - this.referenceTime) / 1000000L;
        }
        return this.elapsedTime / 1000000L;
    }

    public String toString() {
        return Duration.of(this.elapsedTime(), TimeUnit.MILLISECONDS).toString();
    }

    private long now() {
        return System.nanoTime();
    }
}

