/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.kocakosm.pitaya.util.Parameters;

public final class Comparators {
    public static <T> Comparator<T> compose(Comparator<? super T> ... comparators) {
        return Comparators.compose(Arrays.asList(comparators));
    }

    public static <T> Comparator<T> compose(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompositeComparator(comparators);
    }

    public static <T> Comparator<T> reverse(final Comparator<T> comparator) {
        Parameters.checkNotNull(comparator);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -comparator.compare(o1, o2);
            }
        };
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(Parameters.checkNotNull(o2));
            }
        };
    }

    public static <T> Comparator<T> withNullsFirst(final Comparator<T> comparator) {
        Parameters.checkNotNull(comparator);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : comparator.compare(o1, o2)));
            }
        };
    }

    public static <T> Comparator<T> withNullsLast(final Comparator<T> comparator) {
        Parameters.checkNotNull(comparator);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1 == o2 ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : comparator.compare(o1, o2)));
            }
        };
    }

    private Comparators() {
    }

    private static final class CompositeComparator<T>
    implements Comparator<T> {
        private final List<Comparator<? super T>> comparators = new ArrayList<Comparator<? super T>>();

        CompositeComparator(Iterable<? extends Comparator<? super T>> comparators) {
            for (Comparator<T> comparator : comparators) {
                Parameters.checkNotNull(comparator);
                this.comparators.add(comparator);
            }
            Parameters.checkCondition(!this.comparators.isEmpty());
        }

        @Override
        public int compare(T o1, T o2) {
            for (Comparator<T> comparator : this.comparators) {
                int c = comparator.compare(o1, o2);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }
}

