/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

public final class Parameters {
    public static <T> T checkNotNull(T ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        return ref;
    }

    public static <T> T checkNotNull(T ref, String msg, Object ... args) {
        if (ref == null) {
            throw new NullPointerException(Parameters.format(msg, args));
        }
        return ref;
    }

    public static void checkCondition(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkCondition(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(Parameters.format(msg, args));
        }
    }

    public static <T> T checkType(Object ref, Class<T> type) {
        if (type.isInstance(ref)) {
            return type.cast(ref);
        }
        throw new ClassCastException();
    }

    public static <T> T checkType(Object ref, Class<T> type, String msg, Object ... args) {
        if (type.isInstance(ref)) {
            return type.cast(ref);
        }
        throw new ClassCastException(Parameters.format(msg, args));
    }

    private static String format(String format, Object ... args) {
        if (format == null) {
            return null;
        }
        return args != null ? String.format(format, args) : format;
    }

    private Parameters() {
    }
}

