/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.util;

import java.util.Arrays;
import org.kocakosm.pitaya.util.Classes;
import org.kocakosm.pitaya.util.Parameters;

public final class XObjects {
    public static <T> T firstNonNull(T ... refs) {
        for (T ref : refs) {
            if (ref == null) continue;
            return ref;
        }
        return null;
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return XObjects.arrayEquals(a, b);
        }
        return false;
    }

    private static boolean arrayEquals(Object a, Object b) {
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.deepEquals((Object[])a, (Object[])b);
        }
        return false;
    }

    public static int hashCode(Object ... objects) {
        return objects == null ? 0 : (objects.length == 1 ? XObjects.hashCode(objects[0]) : Arrays.hashCode(objects));
    }

    private static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static String toString(Object o) {
        return XObjects.toString(o, "null");
    }

    public static String toString(Object o, String ifNull) {
        return o == null ? ifNull : (o.getClass().isArray() ? XObjects.arrayToString(o) : o.toString());
    }

    private static String arrayToString(Object array) {
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof Object[]) {
            return Arrays.deepToString((Object[])array);
        }
        return array.toString();
    }

    public static ToStringBuilder toStringBuilder(Object self) {
        return XObjects.toStringBuilder(Classes.getShortName(self.getClass()));
    }

    public static ToStringBuilder toStringBuilder(String name) {
        Parameters.checkNotNull(name);
        return new ToStringBuilder(name);
    }

    private XObjects() {
    }

    public static final class ToStringBuilder {
        private final StringBuilder sb;
        private boolean first = true;

        private ToStringBuilder(String name) {
            this.sb = new StringBuilder(128).append(name);
        }

        public ToStringBuilder append(String name, Object value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(XObjects.toString(value));
            return this;
        }

        public ToStringBuilder append(String name, boolean value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, byte value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, int value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, long value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, float value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, double value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(String name, char value) {
            Parameters.checkNotNull(name);
            this.appendSeparator().append(name).append('=').append(value);
            return this;
        }

        public ToStringBuilder append(Object value) {
            this.appendSeparator().append(XObjects.toString(value));
            return this;
        }

        public ToStringBuilder append(boolean value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(byte value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(int value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(long value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(float value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(double value) {
            this.appendSeparator().append(value);
            return this;
        }

        public ToStringBuilder append(char value) {
            this.appendSeparator().append(value);
            return this;
        }

        public String toString() {
            this.sb.append(")");
            return this.sb.toString();
        }

        private StringBuilder appendSeparator() {
            if (this.first) {
                this.sb.append(" (");
                this.first = false;
            } else {
                this.sb.append(", ");
            }
            return this.sb;
        }
    }
}

