/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kocakosm.pitaya.collection.AbstractBag;
import org.kocakosm.pitaya.collection.ConcurrentBag;

public final class CopyOnWriteArrayBag<E>
extends AbstractBag<E>
implements ConcurrentBag<E>,
Serializable {
    private static final long serialVersionUID = 8401510673920814526L;
    private final CopyOnWriteArrayList<E> entries;

    public CopyOnWriteArrayBag() {
        this.entries = new CopyOnWriteArrayList();
    }

    public CopyOnWriteArrayBag(Collection<? extends E> c) {
        this.entries = new CopyOnWriteArrayList<E>(c);
    }

    public CopyOnWriteArrayBag(Iterable<? extends E> i) {
        this();
        for (E e : i) {
            this.add(e);
        }
    }

    public CopyOnWriteArrayBag(Iterator<? extends E> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public CopyOnWriteArrayBag(E ... elements) {
        this(Arrays.asList(elements));
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entries.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entries.removeAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.entries.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.entries.remove(o);
    }

    @Override
    public boolean add(E e) {
        return this.entries.add(e);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int addAllAbsent(Collection<? extends E> c) {
        return this.entries.addAllAbsent(c);
    }

    @Override
    public boolean addIfAbsent(E e) {
        return this.entries.addIfAbsent(e);
    }
}

