/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kocakosm.pitaya.collection.ImmutableList;
import org.kocakosm.pitaya.collection.ImmutableSet;

public final class ImmutableMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 458645004066047051L;
    private final Map<K, V> inner;

    public static <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return new ImmutableMap<K, V>(new LinkedHashMap<K, V>(map));
    }

    private ImmutableMap(Map<K, V> inner) {
        this.inner = inner;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inner.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.inner.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return ImmutableSet.copyOf(this.inner.keySet());
    }

    @Override
    public Collection<V> values() {
        return ImmutableList.copyOf(this.inner.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ImmutableSet.copyOf(this.inner.entrySet());
    }

    public static final class Builder<K, V> {
        private final Map<K, V> inner = new LinkedHashMap();

        public Builder<K, V> put(K key, V value) {
            this.inner.put(key, value);
            return this;
        }

        public Builder<K, V> put(Map<? extends K, ? extends V> map) {
            this.inner.putAll(map);
            return this;
        }

        public Map<K, V> build() {
            return new ImmutableMap(this.inner);
        }
    }
}

