/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.kocakosm.pitaya.charset.Charsets;
import org.kocakosm.pitaya.io.CharStreams;
import org.kocakosm.pitaya.io.IO;
import org.kocakosm.pitaya.io.WriteOption;
import org.kocakosm.pitaya.io.XFiles;
import org.kocakosm.pitaya.util.Parameters;

public final class TextFiles {
    public static List<String> head(File f) throws IOException {
        return TextFiles.head(f, Charsets.DEFAULT);
    }

    public static List<String> head(File f, Charset charset) throws IOException {
        return TextFiles.head(f, 10, charset);
    }

    public static List<String> head(File f, int n) throws IOException {
        return TextFiles.head(f, n, Charsets.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> head(File f, int n, Charset charset) throws IOException {
        Parameters.checkCondition(n >= 0);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = TextFiles.newReader(f, charset);
        try {
            String line = reader.readLine();
            while (line != null && lines.size() < n) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        finally {
            IO.close(reader);
        }
        return Collections.unmodifiableList(lines);
    }

    public static List<String> tail(File f) throws IOException {
        return TextFiles.tail(f, Charsets.DEFAULT);
    }

    public static List<String> tail(File f, Charset charset) throws IOException {
        return TextFiles.tail(f, 10, charset);
    }

    public static List<String> tail(File f, int n) throws IOException {
        return TextFiles.tail(f, n, Charsets.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> tail(File f, int n, Charset charset) throws IOException {
        Parameters.checkCondition(n >= 0);
        if (n == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = TextFiles.newReader(f, charset);
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                if (lines.size() > n) {
                    lines.remove(0);
                }
                line = reader.readLine();
            }
        }
        finally {
            IO.close(reader);
        }
        return Collections.unmodifiableList(lines);
    }

    public static BufferedReader newReader(File f) throws FileNotFoundException {
        return TextFiles.newReader(f, Charsets.DEFAULT);
    }

    public static BufferedReader newReader(File f, Charset charset) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(f);
        return new BufferedReader(new InputStreamReader((InputStream)in, charset));
    }

    public static BufferedWriter newWriter(File f, WriteOption ... options) throws IOException {
        return TextFiles.newWriter(f, Charsets.DEFAULT, options);
    }

    public static BufferedWriter newWriter(File f, Charset charset, WriteOption ... options) throws IOException {
        BufferedOutputStream out = XFiles.newOutputStream(f, options);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)out, charset));
    }

    public static String read(File f) throws IOException {
        return TextFiles.read(f, Charsets.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File f, Charset charset) throws IOException {
        BufferedReader in = TextFiles.newReader(f, charset);
        try {
            String string = CharStreams.read(in);
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    public static List<String> readLines(File f) throws IOException {
        return TextFiles.readLines(f, Charsets.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File f, Charset charset) throws IOException {
        BufferedReader in = TextFiles.newReader(f, charset);
        try {
            List<String> list = CharStreams.readLines(in);
            return list;
        }
        finally {
            IO.close(in);
        }
    }

    private TextFiles() {
    }
}

