/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.kocakosm.pitaya.util.Parameters;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final long serialVersionUID = 2433311932359200182L;
    public static final Fraction ZERO = Fraction.valueOf(0);
    public static final Fraction ONE = Fraction.valueOf(1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    private final BigInteger n;
    private final BigInteger d;
    private final BigDecimal v;

    public static Fraction valueOf(int val) {
        return new Fraction(BigInteger.valueOf(val), BigInteger.ONE);
    }

    public static Fraction valueOf(Integer val) {
        return new Fraction(BigInteger.valueOf(val.intValue()), BigInteger.ONE);
    }

    public static Fraction valueOf(BigInteger val) {
        return new Fraction(val, BigInteger.ONE);
    }

    public static Fraction parse(String str) {
        String fraction = str.replaceAll("\\s", "");
        int index = fraction.indexOf(47);
        if (index < 0) {
            return Fraction.valueOf(new BigInteger(fraction));
        }
        BigInteger n = new BigInteger(fraction.substring(0, index));
        BigInteger d = new BigInteger(fraction.substring(index + 1));
        return new Fraction(n, d);
    }

    public Fraction(int numerator, int denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public Fraction(BigInteger numerator, BigInteger denominator) {
        Parameters.checkCondition(!BigInteger.ZERO.equals(denominator));
        this.n = numerator;
        this.d = denominator;
        this.v = new BigDecimal(this.n).divide(new BigDecimal(this.d), MathContext.DECIMAL128);
    }

    public Fraction plus(Fraction f) {
        return new Fraction(this.n.multiply(f.d).add(f.n.multiply(this.d)), this.d.multiply(f.d)).reduced();
    }

    public Fraction minus(Fraction f) {
        return new Fraction(this.n.multiply(f.d).subtract(f.n.multiply(this.d)), this.d.multiply(f.d)).reduced();
    }

    public Fraction multipliedBy(Fraction f) {
        return new Fraction(this.n.multiply(f.n), this.d.multiply(f.d)).reduced();
    }

    public Fraction dividedBy(Fraction f) {
        if (ZERO.equals(f)) {
            throw new ArithmeticException("Division by zero");
        }
        return new Fraction(this.n.multiply(f.d), this.d.multiply(f.n)).reduced();
    }

    public Fraction power(int exponent) {
        return new Fraction(this.n.pow(exponent), this.d.pow(exponent)).reduced();
    }

    public int sign() {
        return this.n.signum() * this.d.signum();
    }

    public Fraction absoluteValue() {
        return new Fraction(this.n.abs(), this.d.abs());
    }

    public Fraction negated() {
        if (this.d.signum() < 0) {
            return new Fraction(this.n, this.d.negate());
        }
        return new Fraction(this.n.negate(), this.d);
    }

    public Fraction inverted() {
        return new Fraction(this.d, this.n);
    }

    public Fraction reduced() {
        BigInteger gcd = this.n.gcd(this.d);
        if (this.d.signum() < 0) {
            BigInteger numerator = this.n.divide(gcd).negate();
            BigInteger denominator = this.d.divide(gcd).negate();
            return new Fraction(numerator, denominator);
        }
        return new Fraction(this.n.divide(gcd), this.d.divide(gcd));
    }

    public BigInteger numerator() {
        return this.n;
    }

    public BigInteger denominator() {
        return this.d;
    }

    public BigDecimal bigDecimalValue() {
        return this.v;
    }

    @Override
    public int intValue() {
        return this.v.intValue();
    }

    @Override
    public long longValue() {
        return this.v.longValue();
    }

    @Override
    public float floatValue() {
        return this.v.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.v.doubleValue();
    }

    @Override
    public int compareTo(Fraction f) {
        return this.n.multiply(f.d).compareTo(f.n.multiply(this.d));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fraction)) {
            return false;
        }
        Fraction f1 = this.reduced();
        Fraction f2 = ((Fraction)o).reduced();
        return f1.n.equals(f2.n) && f1.d.equals(f2.d);
    }

    public int hashCode() {
        Fraction f = this.reduced();
        int hash = 7;
        hash = 71 * hash + f.n.hashCode();
        hash = 71 * hash + f.d.hashCode();
        return hash;
    }

    public String toString() {
        return this.n + " / " + this.d;
    }
}

