/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.net;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kocakosm.pitaya.charset.ASCII;
import org.kocakosm.pitaya.collection.ImmutableMap;
import org.kocakosm.pitaya.util.Joiner;
import org.kocakosm.pitaya.util.Parameters;
import org.kocakosm.pitaya.util.Strings;
import org.kocakosm.pitaya.util.XObjects;

public final class MediaType
implements Serializable {
    private static final long serialVersionUID = 30386013071308392L;
    private static final String CHARSET;
    private static final String WILDCARD;
    private static final Joiner PARAMS_JOINER;
    private static final Pattern TOKEN_PATTERN;
    private static final Pattern MEDIA_TYPE_PATTERN;
    public static final MediaType ANY_TYPE;
    public static final MediaType ANY_TEXT_TYPE;
    public static final MediaType ANY_IMAGE_TYPE;
    public static final MediaType ANY_AUDIO_TYPE;
    public static final MediaType ANY_VIDEO_TYPE;
    public static final MediaType ANY_APPLICATION_TYPE;
    public static final MediaType JPEG;
    public static final MediaType PNG;
    public static final MediaType GIF;
    public static final MediaType CSS;
    public static final MediaType HTML;
    public static final MediaType PLAIN_TEXT;
    public static final MediaType JSON;
    public static final MediaType XML;
    public static final MediaType OCTET_STREAM;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    public static MediaType parse(String input) {
        Parameters.checkNotNull(input);
        Matcher m = MEDIA_TYPE_PATTERN.matcher(input);
        Parameters.checkCondition(m.matches());
        String type = m.group(1);
        String subtype = m.group(2);
        String params = m.group(3);
        ParametersParser parser = new ParametersParser();
        return MediaType.create(type, subtype, parser.parse(params));
    }

    public static MediaType create(String type, String subtype) {
        Map<String, String> params = Collections.emptyMap();
        return MediaType.create(type, subtype, params);
    }

    private static MediaType create(String type, String subtype, Map<String, String> parameters) {
        Parameters.checkCondition(!WILDCARD.equals(type) || WILDCARD.equals(subtype));
        String normalizedType = MediaType.normalizeToken(type);
        String normalizedSubtype = MediaType.normalizeToken(subtype);
        Map<String, String> params = MediaType.normalizeParameters(parameters);
        return new MediaType(normalizedType, normalizedSubtype, params);
    }

    private static String normalizeToken(String token) {
        Parameters.checkNotNull(token);
        Parameters.checkCondition(TOKEN_PATTERN.matcher(token).matches());
        return ASCII.toLowerCase(token);
    }

    private static Map<String, String> normalizeParameters(Map<String, String> parameters) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String attribute = MediaType.normalizeToken(entry.getKey());
            String value = CHARSET.equals(attribute) ? ASCII.toUpperCase(entry.getValue()) : Parameters.checkNotNull(entry.getValue());
            params.put(attribute, value);
        }
        return params;
    }

    private MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = ImmutableMap.copyOf(parameters);
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public boolean hasWildcard() {
        return WILDCARD.equals(this.type) || WILDCARD.equals(this.subtype);
    }

    public Charset charset() {
        String charset = this.parameters.get(CHARSET);
        return charset == null ? null : Charset.forName(charset);
    }

    public MediaType withCharset(Charset charset) {
        return this.withParameter(CHARSET, charset.name());
    }

    public MediaType withParameter(String attribute, String value) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(attribute, value);
        return this.withParameters(params);
    }

    public MediaType withParameters(Map<String, String> parameters) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.putAll(this.parameters);
        params.putAll(MediaType.normalizeParameters(parameters));
        return new MediaType(this.type, this.subtype, params);
    }

    public MediaType withoutParameter(String attribute) {
        Parameters.checkNotNull(attribute);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.putAll(this.parameters);
        params.remove(attribute);
        return new MediaType(this.type, this.subtype, params);
    }

    public MediaType withoutParameters() {
        return new MediaType(this.type, this.subtype);
    }

    public boolean is(MediaType range) {
        return !(!range.type.equals(WILDCARD) && !range.type.equals(this.type) || !range.subtype.equals(WILDCARD) && !range.subtype.equals(this.subtype) || !this.parameters.entrySet().containsAll(range.parameters.entrySet()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.type.equals(mediaType.type) && this.subtype.equals(mediaType.subtype) && this.parameters.equals(mediaType.parameters);
    }

    public int hashCode() {
        return XObjects.hashCode(this.type, this.subtype, this.parameters);
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return Strings.concat(this.type, "/", this.subtype);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            String attribute = parameter.getKey();
            String value = parameter.getValue();
            if (!TOKEN_PATTERN.matcher(value).matches()) {
                value = this.escapeAndQuote(value);
            }
            params.add(attribute + "=" + value);
        }
        return Strings.concat(this.type, "/", this.subtype, PARAMS_JOINER.join(params));
    }

    private String escapeAndQuote(String value) {
        StringBuilder escaped = new StringBuilder(value.length() * 2);
        escaped.append('\"');
        for (char c : value.toCharArray()) {
            if (c == '\\' || c == '\"') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return escaped.append('\"').toString();
    }

    static {
        WILDCARD = "*";
        CHARSET = "charset";
        PARAMS_JOINER = Joiner.on("; ").withPrefix("; ");
        String token = "[\\p{ASCII}&&[^\\p{Cntrl}\\s\\(\\)<>@,;:\"/\\[\\]\\?=\\\\]]+";
        TOKEN_PATTERN = Pattern.compile(token);
        String quotedString = "\"([\\p{ASCII}&&[^\"\\\\]]|\\\\\\p{ASCII})*\"";
        String regex = Strings.concat("(", token, ")/(", token, ")", "((;[ \t\r\n]*", token, "=(", token, "|", quotedString, "))*)");
        MEDIA_TYPE_PATTERN = Pattern.compile(regex);
        ANY_TYPE = new MediaType(WILDCARD, WILDCARD);
        ANY_TEXT_TYPE = new MediaType("text", WILDCARD);
        ANY_IMAGE_TYPE = new MediaType("image", WILDCARD);
        ANY_AUDIO_TYPE = new MediaType("audio", WILDCARD);
        ANY_VIDEO_TYPE = new MediaType("video", WILDCARD);
        ANY_APPLICATION_TYPE = new MediaType("application", WILDCARD);
        JPEG = new MediaType("image", "jpeg");
        PNG = new MediaType("image", "png");
        GIF = new MediaType("image", "gif");
        CSS = new MediaType("text", "css");
        HTML = new MediaType("text", "html");
        PLAIN_TEXT = new MediaType("text", "plain");
        JSON = new MediaType("application", "json");
        XML = new MediaType("application", "xml");
        OCTET_STREAM = new MediaType("application", "octet-stream");
    }

    private static final class ParametersParser {
        private String params;
        private int index;

        private ParametersParser() {
        }

        Map<String, String> parse(String params) {
            this.params = params;
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            while (this.index < params.length() - 1) {
                m.put(this.readAttribute(), this.readValue());
            }
            return m;
        }

        private String readAttribute() {
            StringBuilder attribute = new StringBuilder();
            char c = this.params.charAt(++this.index);
            while (c != '=') {
                attribute.append(c);
                c = this.params.charAt(++this.index);
            }
            return attribute.toString().trim();
        }

        private String readValue() {
            StringBuilder value = new StringBuilder();
            boolean escaped = false;
            char c = this.params.charAt(++this.index);
            while (c != ';' || escaped) {
                if (c == '\\' && !escaped) {
                    escaped = true;
                } else {
                    escaped = false;
                    value.append(c);
                }
                if (this.index == this.params.length() - 1) break;
                c = this.params.charAt(++this.index);
            }
            if (value.charAt(0) == '\"') {
                return value.substring(1, value.length() - 1);
            }
            return value.toString();
        }
    }
}

