/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.net;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.kocakosm.pitaya.util.Parameters;

public final class URLs {
    public static URL create(String url) {
        Parameters.checkNotNull(url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String relativize(URL base, URL full) {
        try {
            return base.toURI().relativize(full.toURI()).normalize().toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URL resolve(URL base, String path) {
        try {
            return base.toURI().resolve(path).normalize().toURL();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private URLs() {
    }
}

