/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.Algorithm;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.security.HKDF;
import org.kocakosm.pitaya.security.KDF;
import org.kocakosm.pitaya.security.MAC;
import org.kocakosm.pitaya.security.PBKDF1;
import org.kocakosm.pitaya.security.PBKDF2;
import org.kocakosm.pitaya.security.SCrypt;

public final class KDFs {
    public static KDF pbkdf1(Algorithm<Digest> digest, int iterationCount, int dkLen) {
        return new PBKDF1(digest, iterationCount, dkLen);
    }

    public static KDF pbkdf2(Algorithm<MAC> mac, int iterationCount, int dkLen) {
        return new PBKDF2(mac, iterationCount, dkLen);
    }

    public static KDF hkdf(Algorithm<MAC> mac, byte[] info, int dkLen) {
        return new HKDF(mac, info, dkLen);
    }

    public static KDF scrypt(int r, int n, int p, int dkLen) {
        return new SCrypt(r, n, p, dkLen);
    }

    private KDFs() {
    }
}

