/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import java.util.Arrays;
import org.kocakosm.pitaya.security.AbstractDigest;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.util.LittleEndian;
import org.kocakosm.pitaya.util.Parameters;

final class Keccak
extends AbstractDigest {
    private static final long[] RC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private static final int[] R = new int[]{0, 1, 62, 28, 27, 36, 44, 6, 55, 20, 3, 10, 43, 25, 39, 41, 45, 15, 21, 8, 18, 2, 61, 56, 14};
    private final long[] A;
    private final long[] B;
    private final long[] C;
    private final long[] D;
    private final int blockLen;
    private final byte[] buffer;
    private int bufferLen;

    Keccak(int length) {
        super("Keccak-" + length * 8, length);
        Parameters.checkCondition(length == 28 || length == 32 || length == 48 || length == 64);
        this.A = new long[25];
        this.B = new long[25];
        this.C = new long[5];
        this.D = new long[5];
        this.blockLen = 200 - 2 * length;
        this.buffer = new byte[this.blockLen];
        this.bufferLen = 0;
    }

    @Override
    public Digest reset() {
        for (int i = 0; i < 25; ++i) {
            this.A[i] = 0L;
        }
        this.bufferLen = 0;
        return this;
    }

    @Override
    public Digest update(byte input) {
        this.buffer[this.bufferLen] = input;
        if (++this.bufferLen == this.blockLen) {
            this.processBuffer();
        }
        return this;
    }

    @Override
    public Digest update(byte[] input, int off, int len) {
        while (len > 0) {
            int cpLen = Math.min(this.blockLen - this.bufferLen, len);
            System.arraycopy(input, off, this.buffer, this.bufferLen, cpLen);
            this.bufferLen += cpLen;
            off += cpLen;
            len -= cpLen;
            if (this.bufferLen != this.blockLen) continue;
            this.processBuffer();
        }
        return this;
    }

    @Override
    public byte[] digest() {
        this.addPadding();
        this.processBuffer();
        byte[] tmp = new byte[this.length() * 8];
        for (int i = 0; i < this.length(); i += 8) {
            LittleEndian.encode(this.A[i >>> 3], tmp, i);
        }
        this.reset();
        return Arrays.copyOf(tmp, this.length());
    }

    private void addPadding() {
        if (this.bufferLen + 1 == this.buffer.length) {
            this.buffer[this.bufferLen] = -127;
        } else {
            this.buffer[this.bufferLen] = 1;
            for (int i = this.bufferLen + 1; i < this.buffer.length - 1; ++i) {
                this.buffer[i] = 0;
            }
            this.buffer[this.buffer.length - 1] = -128;
        }
    }

    private void processBuffer() {
        for (int i = 0; i < this.buffer.length; i += 8) {
            int n = i >>> 3;
            this.A[n] = this.A[n] ^ LittleEndian.decodeLong(this.buffer, i);
        }
        this.keccakf();
        this.bufferLen = 0;
    }

    private void keccakf() {
        for (int n = 0; n < 24; ++n) {
            this.round(n);
        }
    }

    private void round(int n) {
        int i;
        int y;
        int x;
        for (x = 0; x < 5; ++x) {
            this.C[x] = this.A[this.index(x, 0)] ^ this.A[this.index(x, 1)] ^ this.A[this.index(x, 2)] ^ this.A[this.index(x, 3)] ^ this.A[this.index(x, 4)];
        }
        for (x = 0; x < 5; ++x) {
            this.D[x] = this.C[this.index(x - 1)] ^ this.rot(this.C[this.index(x + 1)], 1);
            for (y = 0; y < 5; ++y) {
                int n2 = this.index(x, y);
                this.A[n2] = this.A[n2] ^ this.D[x];
            }
        }
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                i = this.index(x, y);
                this.B[this.index((int)y, (int)(x * 2 + 3 * y))] = this.rot(this.A[i], R[i]);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                i = this.index(x, y);
                this.A[i] = this.B[i] ^ (this.B[this.index(x + 1, y)] ^ 0xFFFFFFFFFFFFFFFFL) & this.B[this.index(x + 2, y)];
            }
        }
        this.A[0] = this.A[0] ^ RC[n];
    }

    private long rot(long w, int r) {
        return Long.rotateLeft(w, r);
    }

    private int index(int x) {
        return x < 0 ? this.index(x + 5) : x % 5;
    }

    private int index(int x, int y) {
        return this.index(x) + 5 * this.index(y);
    }
}

