/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.AbstractDigest;
import org.kocakosm.pitaya.security.Digest;

final class MD2
extends AbstractDigest {
    private static final int DIGEST_LENGTH = 16;
    private static final int BLOCK_LENGTH = 16;
    private static final byte[] S = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};
    private final byte[] buffer = new byte[16];
    private byte[] checksum;
    private byte[] X;
    private int bufferLen;

    MD2() {
        super("MD2", 16);
        this.reset();
    }

    @Override
    public Digest reset() {
        this.bufferLen = 0;
        this.checksum = new byte[16];
        this.X = new byte[48];
        return this;
    }

    @Override
    public Digest update(byte input) {
        this.buffer[this.bufferLen] = input;
        if (++this.bufferLen == 16) {
            this.processBuffer();
        }
        return this;
    }

    @Override
    public Digest update(byte[] input, int off, int len) {
        while (len > 0) {
            int cpLen = Math.min(16 - this.bufferLen, len);
            System.arraycopy(input, off, this.buffer, this.bufferLen, cpLen);
            this.bufferLen += cpLen;
            off += cpLen;
            len -= cpLen;
            if (this.bufferLen != 16) continue;
            this.processBuffer();
        }
        return this;
    }

    @Override
    public byte[] digest() {
        this.addPadding();
        this.processBuffer();
        this.processChecksum();
        byte[] hash = new byte[16];
        System.arraycopy(this.X, 0, hash, 0, 16);
        this.reset();
        return hash;
    }

    private void addPadding() {
        int len = 16 - this.bufferLen;
        for (int i = this.bufferLen; i < 16; ++i) {
            this.buffer[i] = (byte)len;
        }
    }

    private void updateChecksum() {
        byte l = this.checksum[15];
        for (int i = 0; i < 16; ++i) {
            this.checksum[i] = l = (byte)(this.checksum[i] ^ S[(this.buffer[i] ^ l) & 0xFF]);
        }
    }

    private void processBuffer() {
        this.updateChecksum();
        this.process(this.buffer);
        this.bufferLen = 0;
    }

    private void processChecksum() {
        this.process(this.checksum);
    }

    private void process(byte[] buf) {
        for (int i = 0; i < 16; ++i) {
            byte b;
            this.X[16 + i] = b = buf[i];
            this.X[32 + i] = (byte)(this.X[i] ^ b);
        }
        int t = 0;
        for (int j = 0; j < 18; ++j) {
            for (int k = 0; k < 48; ++k) {
                this.X[k] = t = (int)((byte)(this.X[k] ^ S[t & 0xFF]));
            }
            t = (byte)(t + j);
        }
    }
}

