/*
 * Decompiled with CFR 0.152.
 */
package org.kocakosm.pitaya.security;

import org.kocakosm.pitaya.security.AbstractDigest;
import org.kocakosm.pitaya.security.Digest;
import org.kocakosm.pitaya.util.LittleEndian;

final class MD4
extends AbstractDigest {
    private static final int DIGEST_LENGTH = 16;
    private static final int BLOCK_LENGTH = 64;
    private long counter;
    private final int[] value = new int[4];
    private final byte[] buffer = new byte[64];
    private int bufferLen;

    MD4() {
        super("MD4", 16);
        this.reset();
    }

    @Override
    public Digest reset() {
        this.counter = 0L;
        this.value[0] = 1732584193;
        this.value[1] = -271733879;
        this.value[2] = -1732584194;
        this.value[3] = 271733878;
        this.bufferLen = 0;
        return this;
    }

    @Override
    public Digest update(byte input) {
        this.buffer[this.bufferLen] = input;
        if (++this.bufferLen == 64) {
            this.processBuffer();
        }
        return this;
    }

    @Override
    public Digest update(byte[] input, int off, int len) {
        while (len > 0) {
            int cpLen = Math.min(64 - this.bufferLen, len);
            System.arraycopy(input, off, this.buffer, this.bufferLen, cpLen);
            this.bufferLen += cpLen;
            off += cpLen;
            len -= cpLen;
            if (this.bufferLen != 64) continue;
            this.processBuffer();
        }
        return this;
    }

    @Override
    public byte[] digest() {
        this.addPadding();
        byte[] res = new byte[16];
        LittleEndian.encode(this.value[0], res, 0);
        LittleEndian.encode(this.value[1], res, 4);
        LittleEndian.encode(this.value[2], res, 8);
        LittleEndian.encode(this.value[3], res, 12);
        this.reset();
        return res;
    }

    private void addPadding() {
        int len = 64 - this.bufferLen;
        if (len < 9) {
            len += 64;
        }
        byte[] buf = new byte[len];
        buf[0] = -128;
        for (int i = 1; i < len - 8; ++i) {
            buf[i] = 0;
        }
        this.counter = (this.counter + (long)this.bufferLen) * 8L;
        LittleEndian.encode(this.counter, buf, len - 8);
        this.update(buf);
    }

    private void processBuffer() {
        int A = this.value[0];
        int B = this.value[1];
        int C = this.value[2];
        int D = this.value[3];
        int[] X = new int[16];
        for (int i = 0; i < 16; ++i) {
            X[i] = LittleEndian.decodeInt(this.buffer, 4 * i);
        }
        A = this.FF(A, B, C, D, X[0], 3);
        D = this.FF(D, A, B, C, X[1], 7);
        C = this.FF(C, D, A, B, X[2], 11);
        B = this.FF(B, C, D, A, X[3], 19);
        A = this.FF(A, B, C, D, X[4], 3);
        D = this.FF(D, A, B, C, X[5], 7);
        C = this.FF(C, D, A, B, X[6], 11);
        B = this.FF(B, C, D, A, X[7], 19);
        A = this.FF(A, B, C, D, X[8], 3);
        D = this.FF(D, A, B, C, X[9], 7);
        C = this.FF(C, D, A, B, X[10], 11);
        B = this.FF(B, C, D, A, X[11], 19);
        A = this.FF(A, B, C, D, X[12], 3);
        D = this.FF(D, A, B, C, X[13], 7);
        C = this.FF(C, D, A, B, X[14], 11);
        B = this.FF(B, C, D, A, X[15], 19);
        A = this.GG(A, B, C, D, X[0], 3);
        D = this.GG(D, A, B, C, X[4], 5);
        C = this.GG(C, D, A, B, X[8], 9);
        B = this.GG(B, C, D, A, X[12], 13);
        A = this.GG(A, B, C, D, X[1], 3);
        D = this.GG(D, A, B, C, X[5], 5);
        C = this.GG(C, D, A, B, X[9], 9);
        B = this.GG(B, C, D, A, X[13], 13);
        A = this.GG(A, B, C, D, X[2], 3);
        D = this.GG(D, A, B, C, X[6], 5);
        C = this.GG(C, D, A, B, X[10], 9);
        B = this.GG(B, C, D, A, X[14], 13);
        A = this.GG(A, B, C, D, X[3], 3);
        D = this.GG(D, A, B, C, X[7], 5);
        C = this.GG(C, D, A, B, X[11], 9);
        B = this.GG(B, C, D, A, X[15], 13);
        A = this.HH(A, B, C, D, X[0], 3);
        D = this.HH(D, A, B, C, X[8], 9);
        C = this.HH(C, D, A, B, X[4], 11);
        B = this.HH(B, C, D, A, X[12], 15);
        A = this.HH(A, B, C, D, X[2], 3);
        D = this.HH(D, A, B, C, X[10], 9);
        C = this.HH(C, D, A, B, X[6], 11);
        B = this.HH(B, C, D, A, X[14], 15);
        A = this.HH(A, B, C, D, X[1], 3);
        D = this.HH(D, A, B, C, X[9], 9);
        C = this.HH(C, D, A, B, X[5], 11);
        B = this.HH(B, C, D, A, X[13], 15);
        A = this.HH(A, B, C, D, X[3], 3);
        D = this.HH(D, A, B, C, X[11], 9);
        C = this.HH(C, D, A, B, X[7], 11);
        B = this.HH(B, C, D, A, X[15], 15);
        this.value[0] = this.value[0] + A;
        this.value[1] = this.value[1] + B;
        this.value[2] = this.value[2] + C;
        this.value[3] = this.value[3] + D;
        this.counter += 64L;
        this.bufferLen = 0;
    }

    private int FF(int a, int b, int c, int d, int x, int s) {
        return Integer.rotateLeft(a + this.F(b, c, d) + x, s);
    }

    private int GG(int a, int b, int c, int d, int x, int s) {
        return Integer.rotateLeft(a + this.G(b, c, d) + x + 1518500249, s);
    }

    private int HH(int a, int b, int c, int d, int x, int s) {
        return Integer.rotateLeft(a + this.H(b, c, d) + x + 1859775393, s);
    }

    private int F(int x, int y, int z) {
        return y & x | z & ~x;
    }

    private int G(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private int H(int x, int y, int z) {
        return x ^ y ^ z;
    }
}

