package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAwardMedal() {
    add(intArrayOf(0x1f947), _FirstPlaceMedal)
    add(intArrayOf(0x1f948), _SecondPlaceMedal)
    add(intArrayOf(0x1f949), _ThirdPlaceMedal)
    add(intArrayOf(0x1f3c5), _SportsMedal)
    add(intArrayOf(0x1f396, 0xfe0f), _MilitaryMedal)
    add(intArrayOf(0x1f396), _MilitaryMedal)
    add(intArrayOf(0x1f3c6), _Trophy)
}

internal fun MutableList<Emoji>.addAllAwardMedal() {
    add(_FirstPlaceMedal)
    add(_SecondPlaceMedal)
    add(_ThirdPlaceMedal)
    add(_SportsMedal)
    add(_MilitaryMedal)
    add(_Trophy)
}

/**
 * All Emoji of the Activities: award-medal subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAwardMedal(): List<Emoji> =
    ArrayList<Emoji>(6).apply { addAllAwardMedal() }
