package org.kodein.emoji.animals_nature.animal_bird

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Dove: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕊️",
        description = "dove",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("dove", "peace"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Animals & Nature: animal-bird: dove.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Dove: Emoji get() = _Dove

/**
 * Alias to emoji [Dove] (Animals & Nature: animal-bird: dove).
*/
public val Emoji.Companion.Peace: Emoji get() = _Dove
