package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagYemen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇾🇪",
        description = "flag: Yemen",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-yemen", "yemen-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Yemen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagYemen: Emoji get() = _FlagYemen

/**
 * Alias to emoji [FlagYemen] (Flags: country-flag: flag: Yemen).
*/
public val Emoji.Companion.YemenFlag: Emoji get() = _FlagYemen
