package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RolledUpNewspaper: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗞️",
        description = "rolled-up newspaper",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("rolled-up-newspaper", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: book-paper: rolled-up newspaper.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RolledUpNewspaper: Emoji get() = _RolledUpNewspaper
