package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlatShoe: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥿",
        description = "flat shoe",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("flat-shoe", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: flat shoe.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlatShoe: Emoji get() = _FlatShoe
