package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PersonLiftingWeights: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🏋️",
        description = "person lifting weights",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("person-lifting-weights", "lifting-weights"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    uqString = "🏋",
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person lifting weights.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonLiftingWeights: SkinTone1Emoji get() = _PersonLiftingWeights

/**
 * Alias to emoji [PersonLiftingWeights] (People & Body: person-sport: person lifting weights).
*/
public val Emoji.Companion.LiftingWeights: SkinTone1Emoji get() = _PersonLiftingWeights
