package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceHand() {
    add(intArrayOf(0x1fae1), _SalutingFace)
    add(intArrayOf(0x1f914), _ThinkingFace)
    add(intArrayOf(0x1f92b), _ShushingFace)
    add(intArrayOf(0x1fae2), _FaceWithOpenEyesAndHandOverMouth)
    add(intArrayOf(0x1f92d), _FaceWithHandOverMouth)
    add(intArrayOf(0x1f917), _SmilingFaceWithOpenHands)
    add(intArrayOf(0x1fae3), _FaceWithPeekingEye)
}

internal fun MutableList<Emoji>.addAllFaceHand() {
    add(_SalutingFace)
    add(_ThinkingFace)
    add(_ShushingFace)
    add(_FaceWithOpenEyesAndHandOverMouth)
    add(_FaceWithHandOverMouth)
    add(_SmilingFaceWithOpenHands)
    add(_FaceWithPeekingEye)
}

/**
 * All Emoji of the Smileys & Emotion: face-hand subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceHand(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllFaceHand() }
