package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShuffleTracksButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔀",
        description = "shuffle tracks button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("shuffle-tracks-button", "shuffle", "twisted-rightwards-arrows"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: shuffle tracks button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShuffleTracksButton: Emoji get() = _ShuffleTracksButton

/**
 * Alias to emoji [ShuffleTracksButton] (Symbols: av-symbol: shuffle tracks button).
*/
public val Emoji.Companion.Shuffle: Emoji get() = _ShuffleTracksButton

/**
 * Alias to emoji [ShuffleTracksButton] (Symbols: av-symbol: shuffle tracks button).
*/
public val Emoji.Companion.TwistedRightwardsArrows: Emoji get() = _ShuffleTracksButton
