package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NotebookWithDecorativeCover: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📔",
        description = "notebook with decorative cover",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("notebook-with-decorative-cover", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: book-paper: notebook with decorative cover.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NotebookWithDecorativeCover: Emoji get() = _NotebookWithDecorativeCover
