package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InboxTray: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📥",
        description = "inbox tray",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("inbox-tray", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: mail: inbox tray.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InboxTray: Emoji get() = _InboxTray
