package org.kodein.emoji.objects.writing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllWriting() {
    add(intArrayOf(0x1f58c, 0xfe0f), _Paintbrush)
    add(intArrayOf(0x1f58c), _Paintbrush)
    add(intArrayOf(0x1f58d, 0xfe0f), _Crayon)
    add(intArrayOf(0x1f58d), _Crayon)
    add(intArrayOf(0x1f58a, 0xfe0f), _Pen)
    add(intArrayOf(0x1f58a), _Pen)
    add(intArrayOf(0x1f58b, 0xfe0f), _FountainPen)
    add(intArrayOf(0x1f58b), _FountainPen)
    add(intArrayOf(0x2712, 0xfe0f), _BlackNib)
    add(intArrayOf(0x2712), _BlackNib)
    add(intArrayOf(0x270f, 0xfe0f), _Pencil)
    add(intArrayOf(0x270f), _Pencil)
    add(intArrayOf(0x1f4dd), _Memo)
}

internal fun MutableList<Emoji>.addAllWriting() {
    add(_Paintbrush)
    add(_Crayon)
    add(_Pen)
    add(_FountainPen)
    add(_BlackNib)
    add(_Pencil)
    add(_Memo)
}

/**
 * All Emoji of the Objects: writing subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allWriting(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllWriting() }
