package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllCatFace() {
    add(intArrayOf(0x1f63a), _GrinningCat)
    add(intArrayOf(0x1f638), _GrinningCatWithSmilingEyes)
    add(intArrayOf(0x1f639), _CatWithTearsOfJoy)
    add(intArrayOf(0x1f63b), _SmilingCatWithHeartEyes)
    add(intArrayOf(0x1f63c), _CatWithWrySmile)
    add(intArrayOf(0x1f63d), _KissingCat)
    add(intArrayOf(0x1f640), _WearyCat)
    add(intArrayOf(0x1f63f), _CryingCat)
    add(intArrayOf(0x1f63e), _PoutingCat)
}

internal fun MutableList<Emoji>.addAllCatFace() {
    add(_GrinningCat)
    add(_GrinningCatWithSmilingEyes)
    add(_CatWithTearsOfJoy)
    add(_SmilingCatWithHeartEyes)
    add(_CatWithWrySmile)
    add(_KissingCat)
    add(_WearyCat)
    add(_CryingCat)
    add(_PoutingCat)
}

/**
 * All Emoji of the Smileys & Emotion: cat-face subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allCatFace(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllCatFace() }
