package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _VsButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆚",
        description = "VS button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("vs-button", "vs"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: VS button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VsButton: Emoji get() = _VsButton

/**
 * Alias to emoji [VsButton] (Symbols: alphanum: VS button).
*/
public val Emoji.Companion.Vs: Emoji get() = _VsButton
