package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagElSalvador: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇻",
        description = "flag: El Salvador",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-el-salvador", "el-salvador-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: El Salvador.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagElSalvador: Emoji get() = _FlagElSalvador

/**
 * Alias to emoji [FlagElSalvador] (Flags: country-flag: flag: El Salvador).
*/
public val Emoji.Companion.ElSalvadorFlag: Emoji get() = _FlagElSalvador
