package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuadeloupe: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇵",
        description = "flag: Guadeloupe",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guadeloupe", "guadeloupe-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guadeloupe.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuadeloupe: Emoji get() = _FlagGuadeloupe

/**
 * Alias to emoji [FlagGuadeloupe] (Flags: country-flag: flag: Guadeloupe).
*/
public val Emoji.Companion.GuadeloupeFlag: Emoji get() = _FlagGuadeloupe
