package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKuwait: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇼",
        description = "flag: Kuwait",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kuwait", "kuwait-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kuwait.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKuwait: Emoji get() = _FlagKuwait

/**
 * Alias to emoji [FlagKuwait] (Flags: country-flag: flag: Kuwait).
*/
public val Emoji.Companion.KuwaitFlag: Emoji get() = _FlagKuwait
