package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSweden: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇪",
        description = "flag: Sweden",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-sweden", "sweden-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sweden.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSweden: Emoji get() = _FlagSweden

/**
 * Alias to emoji [FlagSweden] (Flags: country-flag: flag: Sweden).
*/
public val Emoji.Companion.SwedenFlag: Emoji get() = _FlagSweden
