package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithHandOverMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤭",
        description = "face with hand over mouth",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("face-with-hand-over-mouth", "smiling-eyes-with-hand-over-mouth", "chuckling"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: face with hand over mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithHandOverMouth: Emoji get() = _FaceWithHandOverMouth

/**
 * Alias to emoji [FaceWithHandOverMouth] (Smileys & Emotion: face-hand: face with hand over mouth).
*/
public val Emoji.Companion.SmilingEyesWithHandOverMouth: Emoji get() = _FaceWithHandOverMouth

/**
 * Alias to emoji [FaceWithHandOverMouth] (Smileys & Emotion: face-hand: face with hand over mouth).
*/
public val Emoji.Companion.Chuckling: Emoji get() = _FaceWithHandOverMouth
