package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithSteamFromNose: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😤",
        description = "face with steam from nose",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-with-steam-from-nose", "triumph"),
        emoticons = listOf("(((╬◣﹏◢)))"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: face with steam from nose.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithSteamFromNose: Emoji get() = _FaceWithSteamFromNose

/**
 * Alias to emoji [FaceWithSteamFromNose] (Smileys & Emotion: face-negative: face with steam from nose).
*/
public val Emoji.Companion.Triumph: Emoji get() = _FaceWithSteamFromNose
